// Boost.Geometry

// Copyright (c) 2017, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)


#ifndef BOOST_GEOMETRY_PROJECTIONS_IAU2000_HPP
#define BOOST_GEOMETRY_PROJECTIONS_IAU2000_HPP


#include <boost/geometry/srs/projections/code.hpp>


namespace boost { namespace geometry { namespace projections
{


#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

    inline std::string iau2000_to_string(int code)
    {
        static const code_element arr[] = {
            {19900, "+proj=longlat +a=2439700 +b=2439700 +no_defs"},
            {19901, "+proj=longlat +a=2439700 +b=2439700 +no_defs"},
            //{19910, ""},
            //{19911, ""},
            //{19912, ""},
            //{19913, ""},
            {19914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            //{19968, ""},
            //{19969, ""},
            //{19970, ""},
            //{19971, ""},
            {19972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            {19973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs"},
            //{19974, ""},
            //{19975, ""},
            //{19976, ""},
            //{19977, ""},
            //{19978, ""},
            //{19979, ""},
            {29900, "+proj=longlat +a=6051800 +b=6051800 +no_defs"},
            {29901, "+proj=longlat +a=6051800 +b=6051800 +no_defs"},
            //{29910, ""},
            //{29911, ""},
            //{29912, ""},
            //{29913, ""},
            {29914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            //{29968, ""},
            //{29969, ""},
            //{29970, ""},
            //{29971, ""},
            {29972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            {29973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs"},
            //{29974, ""},
            //{29975, ""},
            //{29976, ""},
            //{29977, ""},
            //{29978, ""},
            //{29979, ""},
            {30100, "+proj=longlat +a=1737400 +b=1737400 +no_defs"},
            {30101, "+proj=longlat +a=1737400 +b=1737400 +no_defs"},
            //{30110, ""},
            //{30111, ""},
            //{30112, ""},
            //{30113, ""},
            {30114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            //{30168, ""},
            //{30169, ""},
            //{30170, ""},
            //{30171, ""},
            {30172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            {30173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs"},
            //{30174, ""},
            //{30175, ""},
            //{30176, ""},
            //{30177, ""},
            //{30178, ""},
            //{30179, ""},
            {39900, "+proj=longlat +a=6378140 +b=6356750 +no_defs"},
            {39901, "+proj=longlat +a=6378140 +b=6356750 +no_defs"},
            //{39910, ""},
            //{39911, ""},
            //{39912, ""},
            //{39913, ""},
            {39914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            //{39968, ""},
            //{39969, ""},
            //{39970, ""},
            //{39971, ""},
            {39972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            {39973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs"},
            //{39974, ""},
            //{39975, ""},
            //{39976, ""},
            //{39977, ""},
            //{39978, ""},
            //{39979, ""},
            {40100, "+proj=longlat +a=13400 +b=9200 +no_defs"},
            {40101, "+proj=longlat +a=13400 +b=9200 +no_defs"},
            //{40110, ""},
            //{40111, ""},
            //{40112, ""},
            //{40113, ""},
            {40114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            //{40168, ""},
            //{40169, ""},
            //{40170, ""},
            //{40171, ""},
            {40172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            {40173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs"},
            //{40174, ""},
            //{40175, ""},
            //{40176, ""},
            //{40177, ""},
            //{40178, ""},
            //{40179, ""},
            {40200, "+proj=longlat +a=7500 +b=5200 +no_defs"},
            {40201, "+proj=longlat +a=7500 +b=5200 +no_defs"},
            //{40210, ""},
            //{40211, ""},
            //{40212, ""},
            //{40213, ""},
            {40214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            //{40268, ""},
            //{40269, ""},
            //{40270, ""},
            //{40271, ""},
            {40272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            {40273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs"},
            //{40274, ""},
            //{40275, ""},
            //{40276, ""},
            //{40277, ""},
            //{40278, ""},
            //{40279, ""},
            {49900, "+proj=longlat +a=3396190 +b=3376200 +no_defs"},
            {49901, "+proj=longlat +a=3396190 +b=3376200 +no_defs"},
            //{49910, ""},
            //{49911, ""},
            //{49912, ""},
            //{49913, ""},
            {49914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            //{49968, ""},
            //{49969, ""},
            //{49970, ""},
            //{49971, ""},
            {49972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            {49973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs"},
            //{49974, ""},
            //{49975, ""},
            //{49976, ""},
            //{49977, ""},
            //{49978, ""},
            //{49979, ""},
            {50100, "+proj=longlat +a=1829400 +b=1815700 +no_defs"},
            {50101, "+proj=longlat +a=1829400 +b=1815700 +no_defs"},
            //{50110, ""},
            //{50111, ""},
            //{50112, ""},
            //{50113, ""},
            {50114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            //{50168, ""},
            //{50169, ""},
            //{50170, ""},
            //{50171, ""},
            {50172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            {50173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs"},
            //{50174, ""},
            //{50175, ""},
            //{50176, ""},
            //{50177, ""},
            //{50178, ""},
            //{50179, ""},
            {50200, "+proj=longlat +a=1564130 +b=1560930 +no_defs"},
            {50201, "+proj=longlat +a=1564130 +b=1560930 +no_defs"},
            //{50210, ""},
            //{50211, ""},
            //{50212, ""},
            //{50213, ""},
            {50214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            //{50268, ""},
            //{50269, ""},
            //{50270, ""},
            //{50271, ""},
            {50272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            {50273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs"},
            //{50274, ""},
            //{50275, ""},
            //{50276, ""},
            //{50277, ""},
            //{50278, ""},
            //{50279, ""},
            {50300, "+proj=longlat +a=2632400 +b=2632350 +no_defs"},
            {50301, "+proj=longlat +a=2632400 +b=2632350 +no_defs"},
            //{50310, ""},
            //{50311, ""},
            //{50312, ""},
            //{50313, ""},
            {50314, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50315, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50316, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50317, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50318, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50319, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50320, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50321, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50360, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50361, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50362, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50363, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50364, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50365, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50366, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50367, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            //{50368, ""},
            //{50369, ""},
            //{50370, ""},
            //{50371, ""},
            {50372, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            {50373, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs"},
            //{50374, ""},
            //{50375, ""},
            //{50376, ""},
            //{50377, ""},
            //{50378, ""},
            //{50379, ""},
            {50400, "+proj=longlat +a=2409400 +b=2409300 +no_defs"},
            {50401, "+proj=longlat +a=2409400 +b=2409300 +no_defs"},
            //{50410, ""},
            //{50411, ""},
            //{50412, ""},
            //{50413, ""},
            {50414, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50415, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50416, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50417, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50418, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50419, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50420, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50421, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50460, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50461, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50462, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50463, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50464, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50465, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50466, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50467, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            //{50468, ""},
            //{50469, ""},
            //{50470, ""},
            //{50471, ""},
            {50472, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            {50473, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs"},
            //{50474, ""},
            //{50475, ""},
            //{50476, ""},
            //{50477, ""},
            //{50478, ""},
            //{50479, ""},
            {50500, "+proj=longlat +a=125000 +b=64000 +no_defs"},
            {50501, "+proj=longlat +a=125000 +b=64000 +no_defs"},
            //{50510, ""},
            //{50511, ""},
            //{50512, ""},
            //{50513, ""},
            {50514, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50515, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50516, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50517, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50518, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50519, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50520, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50521, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50560, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50561, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50562, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50563, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50564, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50565, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50566, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50567, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            //{50568, ""},
            //{50569, ""},
            //{50570, ""},
            //{50571, ""},
            {50572, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            {50573, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs"},
            //{50574, ""},
            //{50575, ""},
            //{50576, ""},
            //{50577, ""},
            //{50578, ""},
            //{50579, ""},
            {50600, "+proj=longlat +a=85000 +b=85000 +no_defs"},
            {50601, "+proj=longlat +a=85000 +b=85000 +no_defs"},
            //{50610, ""},
            //{50611, ""},
            //{50612, ""},
            //{50613, ""},
            {50614, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50615, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50616, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50617, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50618, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50619, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50620, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50621, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50660, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50661, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50662, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50663, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50664, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50665, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50666, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50667, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            //{50668, ""},
            //{50669, ""},
            //{50670, ""},
            //{50671, ""},
            {50672, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            {50673, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs"},
            //{50674, ""},
            //{50675, ""},
            //{50676, ""},
            //{50677, ""},
            //{50678, ""},
            //{50679, ""},
            {50700, "+proj=longlat +a=40000 +b=40000 +no_defs"},
            {50701, "+proj=longlat +a=40000 +b=40000 +no_defs"},
            //{50710, ""},
            //{50711, ""},
            //{50712, ""},
            //{50713, ""},
            {50714, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50715, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50716, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50717, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50718, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50719, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50720, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50721, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50760, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50761, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50762, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50763, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50764, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50765, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50766, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50767, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            //{50768, ""},
            //{50769, ""},
            //{50770, ""},
            //{50771, ""},
            {50772, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {50773, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            //{50774, ""},
            //{50775, ""},
            //{50776, ""},
            //{50777, ""},
            //{50778, ""},
            //{50779, ""},
            {50800, "+proj=longlat +a=18000 +b=18000 +no_defs"},
            {50801, "+proj=longlat +a=18000 +b=18000 +no_defs"},
            //{50810, ""},
            //{50811, ""},
            //{50812, ""},
            //{50813, ""},
            {50814, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50815, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50816, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50817, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50818, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50819, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50820, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50821, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50860, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50861, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50862, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50863, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50864, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50865, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50866, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50867, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            //{50868, ""},
            //{50869, ""},
            //{50870, ""},
            //{50871, ""},
            {50872, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            {50873, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs"},
            //{50874, ""},
            //{50875, ""},
            //{50876, ""},
            //{50877, ""},
            //{50878, ""},
            //{50879, ""},
            {50900, "+proj=longlat +a=14000 +b=14000 +no_defs"},
            {50901, "+proj=longlat +a=14000 +b=14000 +no_defs"},
            //{50910, ""},
            //{50911, ""},
            //{50912, ""},
            //{50913, ""},
            {50914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            //{50968, ""},
            //{50969, ""},
            //{50970, ""},
            //{50971, ""},
            {50972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            {50973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs"},
            //{50974, ""},
            //{50975, ""},
            //{50976, ""},
            //{50977, ""},
            //{50978, ""},
            //{50979, ""},
            {51000, "+proj=longlat +a=12000 +b=12000 +no_defs"},
            {51001, "+proj=longlat +a=12000 +b=12000 +no_defs"},
            //{51010, ""},
            //{51011, ""},
            //{51012, ""},
            //{51013, ""},
            {51014, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51015, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51016, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51017, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51018, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51019, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51020, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51021, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51060, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51061, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51062, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51063, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51064, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51065, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51066, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51067, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            //{51068, ""},
            //{51069, ""},
            //{51070, ""},
            //{51071, ""},
            {51072, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            {51073, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs"},
            //{51074, ""},
            //{51075, ""},
            //{51076, ""},
            //{51077, ""},
            //{51078, ""},
            //{51079, ""},
            {51100, "+proj=longlat +a=15000 +b=15000 +no_defs"},
            {51101, "+proj=longlat +a=15000 +b=15000 +no_defs"},
            //{51110, ""},
            //{51111, ""},
            //{51112, ""},
            //{51113, ""},
            {51114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            //{51168, ""},
            //{51169, ""},
            //{51170, ""},
            //{51171, ""},
            {51172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {51173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            //{51174, ""},
            //{51175, ""},
            //{51176, ""},
            //{51177, ""},
            //{51178, ""},
            //{51179, ""},
            {51200, "+proj=longlat +a=10000 +b=10000 +no_defs"},
            {51201, "+proj=longlat +a=10000 +b=10000 +no_defs"},
            //{51210, ""},
            //{51211, ""},
            //{51212, ""},
            //{51213, ""},
            {51214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            //{51268, ""},
            //{51269, ""},
            //{51270, ""},
            //{51271, ""},
            {51272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {51273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            //{51274, ""},
            //{51275, ""},
            //{51276, ""},
            //{51277, ""},
            //{51278, ""},
            //{51279, ""},
            {51300, "+proj=longlat +a=5000 +b=5000 +no_defs"},
            {51301, "+proj=longlat +a=5000 +b=5000 +no_defs"},
            //{51310, ""},
            //{51311, ""},
            //{51312, ""},
            //{51313, ""},
            {51314, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51315, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51316, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51317, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51318, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51319, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51320, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51321, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51360, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51361, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51362, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51363, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51364, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51365, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51366, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51367, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            //{51368, ""},
            //{51369, ""},
            //{51370, ""},
            //{51371, ""},
            {51372, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            {51373, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs"},
            //{51374, ""},
            //{51375, ""},
            //{51376, ""},
            //{51377, ""},
            //{51378, ""},
            //{51379, ""},
            {51400, "+proj=longlat +a=58000 +b=42000 +no_defs"},
            {51401, "+proj=longlat +a=58000 +b=42000 +no_defs"},
            //{51410, ""},
            //{51411, ""},
            //{51412, ""},
            //{51413, ""},
            {51414, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51415, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51416, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51417, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51418, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51419, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51420, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51421, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51460, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51461, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51462, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51463, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51464, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51465, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51466, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51467, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            //{51468, ""},
            //{51469, ""},
            //{51470, ""},
            //{51471, ""},
            {51472, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            {51473, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs"},
            //{51474, ""},
            //{51475, ""},
            //{51476, ""},
            //{51477, ""},
            //{51478, ""},
            //{51479, ""},
            {51500, "+proj=longlat +a=10000 +b=7000 +no_defs"},
            {51501, "+proj=longlat +a=10000 +b=7000 +no_defs"},
            //{51510, ""},
            //{51511, ""},
            //{51512, ""},
            //{51513, ""},
            {51514, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51515, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51516, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51517, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51518, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51519, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51520, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51521, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51560, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51561, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51562, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51563, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51564, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51565, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51566, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51567, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            //{51568, ""},
            //{51569, ""},
            //{51570, ""},
            //{51571, ""},
            {51572, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            {51573, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs"},
            //{51574, ""},
            //{51575, ""},
            //{51576, ""},
            //{51577, ""},
            //{51578, ""},
            //{51579, ""},
            {51600, "+proj=longlat +a=21500 +b=21500 +no_defs"},
            {51601, "+proj=longlat +a=21500 +b=21500 +no_defs"},
            //{51610, ""},
            //{51611, ""},
            //{51612, ""},
            //{51613, ""},
            {51614, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51615, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51616, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51617, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51618, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51619, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51620, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51621, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51660, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51661, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51662, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51663, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51664, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51665, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51666, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51667, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            //{51668, ""},
            //{51669, ""},
            //{51670, ""},
            //{51671, ""},
            {51672, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            {51673, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs"},
            //{51674, ""},
            //{51675, ""},
            //{51676, ""},
            //{51677, ""},
            //{51678, ""},
            //{51679, ""},
            {59900, "+proj=longlat +a=71492000 +b=66854000 +no_defs"},
            {59901, "+proj=longlat +a=71492000 +b=66854000 +no_defs"},
            //{59910, ""},
            //{59911, ""},
            //{59912, ""},
            //{59913, ""},
            {59914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            //{59968, ""},
            //{59969, ""},
            //{59970, ""},
            //{59971, ""},
            {59972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            {59973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs"},
            //{59974, ""},
            //{59975, ""},
            //{59976, ""},
            //{59977, ""},
            //{59978, ""},
            //{59979, ""},
            {60100, "+proj=longlat +a=209100 +b=191400 +no_defs"},
            {60101, "+proj=longlat +a=209100 +b=191400 +no_defs"},
            //{60110, ""},
            //{60111, ""},
            //{60112, ""},
            //{60113, ""},
            {60114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            //{60168, ""},
            //{60169, ""},
            //{60170, ""},
            //{60171, ""},
            {60172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            {60173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs"},
            //{60174, ""},
            //{60175, ""},
            //{60176, ""},
            //{60177, ""},
            //{60178, ""},
            //{60179, ""},
            {60200, "+proj=longlat +a=256300 +b=244600 +no_defs"},
            {60201, "+proj=longlat +a=256300 +b=244600 +no_defs"},
            //{60210, ""},
            //{60211, ""},
            //{60212, ""},
            //{60213, ""},
            {60214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            //{60268, ""},
            //{60269, ""},
            //{60270, ""},
            //{60271, ""},
            {60272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            {60273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs"},
            //{60274, ""},
            //{60275, ""},
            //{60276, ""},
            //{60277, ""},
            //{60278, ""},
            //{60279, ""},
            {60300, "+proj=longlat +a=535600 +b=525800 +no_defs"},
            {60301, "+proj=longlat +a=535600 +b=525800 +no_defs"},
            //{60310, ""},
            //{60311, ""},
            //{60312, ""},
            //{60313, ""},
            {60314, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60315, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60316, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60317, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60318, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60319, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60320, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60321, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60360, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60361, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60362, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60363, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60364, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60365, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60366, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60367, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            //{60368, ""},
            //{60369, ""},
            //{60370, ""},
            //{60371, ""},
            {60372, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            {60373, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs"},
            //{60374, ""},
            //{60375, ""},
            //{60376, ""},
            //{60377, ""},
            //{60378, ""},
            //{60379, ""},
            {60400, "+proj=longlat +a=560000 +b=560000 +no_defs"},
            {60401, "+proj=longlat +a=560000 +b=560000 +no_defs"},
            //{60410, ""},
            //{60411, ""},
            //{60412, ""},
            //{60413, ""},
            {60414, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60415, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60416, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60417, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60418, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60419, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60420, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60421, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60460, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60461, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60462, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60463, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60464, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60465, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60466, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60467, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            //{60468, ""},
            //{60469, ""},
            //{60470, ""},
            //{60471, ""},
            {60472, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            {60473, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs"},
            //{60474, ""},
            //{60475, ""},
            //{60476, ""},
            //{60477, ""},
            //{60478, ""},
            //{60479, ""},
            {60500, "+proj=longlat +a=764000 +b=764000 +no_defs"},
            {60501, "+proj=longlat +a=764000 +b=764000 +no_defs"},
            //{60510, ""},
            //{60511, ""},
            //{60512, ""},
            //{60513, ""},
            {60514, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60515, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60516, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60517, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60518, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60519, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60520, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60521, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60560, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60561, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60562, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60563, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60564, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60565, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60566, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60567, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            //{60568, ""},
            //{60569, ""},
            //{60570, ""},
            //{60571, ""},
            {60572, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            {60573, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs"},
            //{60574, ""},
            //{60575, ""},
            //{60576, ""},
            //{60577, ""},
            //{60578, ""},
            //{60579, ""},
            {60600, "+proj=longlat +a=2575000 +b=2575000 +no_defs"},
            {60601, "+proj=longlat +a=2575000 +b=2575000 +no_defs"},
            //{60610, ""},
            //{60611, ""},
            //{60612, ""},
            //{60613, ""},
            {60614, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60615, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60616, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60617, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60618, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60619, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60620, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60621, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60660, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60661, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60662, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60663, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60664, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60665, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60666, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60667, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            //{60668, ""},
            //{60669, ""},
            //{60670, ""},
            //{60671, ""},
            {60672, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            {60673, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs"},
            //{60674, ""},
            //{60675, ""},
            //{60676, ""},
            //{60677, ""},
            //{60678, ""},
            //{60679, ""},
            {60700, "+proj=longlat +a=164000 +b=107000 +no_defs"},
            {60701, "+proj=longlat +a=164000 +b=107000 +no_defs"},
            //{60710, ""},
            //{60711, ""},
            //{60712, ""},
            //{60713, ""},
            {60714, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60715, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60716, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60717, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60718, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60719, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60720, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60721, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60760, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60761, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60762, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60763, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60764, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60765, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60766, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60767, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            //{60768, ""},
            //{60769, ""},
            //{60770, ""},
            //{60771, ""},
            {60772, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            {60773, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs"},
            //{60774, ""},
            //{60775, ""},
            //{60776, ""},
            //{60777, ""},
            //{60778, ""},
            //{60779, ""},
            {60800, "+proj=longlat +a=718000 +b=718000 +no_defs"},
            {60801, "+proj=longlat +a=718000 +b=718000 +no_defs"},
            //{60810, ""},
            //{60811, ""},
            //{60812, ""},
            //{60813, ""},
            {60814, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60815, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60816, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60817, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60818, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60819, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60820, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60821, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60860, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60861, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60862, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60863, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60864, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60865, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60866, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60867, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            //{60868, ""},
            //{60869, ""},
            //{60870, ""},
            //{60871, ""},
            {60872, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            {60873, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs"},
            //{60874, ""},
            //{60875, ""},
            //{60876, ""},
            //{60877, ""},
            //{60878, ""},
            //{60879, ""},
            {60900, "+proj=longlat +a=115000 +b=105000 +no_defs"},
            {60901, "+proj=longlat +a=115000 +b=105000 +no_defs"},
            //{60910, ""},
            //{60911, ""},
            //{60912, ""},
            //{60913, ""},
            {60914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            //{60968, ""},
            //{60969, ""},
            //{60970, ""},
            //{60971, ""},
            {60972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            {60973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs"},
            //{60974, ""},
            //{60975, ""},
            //{60976, ""},
            //{60977, ""},
            //{60978, ""},
            //{60979, ""},
            {61000, "+proj=longlat +a=97000 +b=77000 +no_defs"},
            {61001, "+proj=longlat +a=97000 +b=77000 +no_defs"},
            //{61010, ""},
            //{61011, ""},
            //{61012, ""},
            //{61013, ""},
            {61014, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61015, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61016, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61017, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61018, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61019, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61020, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61021, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61060, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61061, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61062, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61063, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61064, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61065, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61066, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61067, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            //{61068, ""},
            //{61069, ""},
            //{61070, ""},
            //{61071, ""},
            {61072, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            {61073, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs"},
            //{61074, ""},
            //{61075, ""},
            //{61076, ""},
            //{61077, ""},
            //{61078, ""},
            //{61079, ""},
            {61100, "+proj=longlat +a=69000 +b=55000 +no_defs"},
            {61101, "+proj=longlat +a=69000 +b=55000 +no_defs"},
            //{61110, ""},
            //{61111, ""},
            //{61112, ""},
            //{61113, ""},
            {61114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            //{61168, ""},
            //{61169, ""},
            //{61170, ""},
            //{61171, ""},
            {61172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            {61173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs"},
            //{61174, ""},
            //{61175, ""},
            //{61176, ""},
            //{61177, ""},
            //{61178, ""},
            //{61179, ""},
            {61200, "+proj=longlat +a=16000 +b=16000 +no_defs"},
            {61201, "+proj=longlat +a=16000 +b=16000 +no_defs"},
            //{61210, ""},
            //{61211, ""},
            //{61212, ""},
            //{61213, ""},
            {61214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            //{61268, ""},
            //{61269, ""},
            //{61270, ""},
            //{61271, ""},
            {61272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            {61273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs"},
            //{61274, ""},
            //{61275, ""},
            //{61276, ""},
            //{61277, ""},
            //{61278, ""},
            //{61279, ""},
            {61300, "+proj=longlat +a=15000 +b=7500 +no_defs"},
            {61301, "+proj=longlat +a=15000 +b=7500 +no_defs"},
            //{61310, ""},
            //{61311, ""},
            //{61312, ""},
            //{61313, ""},
            {61314, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61315, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61316, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61317, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61318, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61319, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61320, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61321, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61360, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61361, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61362, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61363, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61364, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61365, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61366, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61367, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            //{61368, ""},
            //{61369, ""},
            //{61370, ""},
            //{61371, ""},
            {61372, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            {61373, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs"},
            //{61374, ""},
            //{61375, ""},
            //{61376, ""},
            //{61377, ""},
            //{61378, ""},
            //{61379, ""},
            {61400, "+proj=longlat +a=15000 +b=8000 +no_defs"},
            {61401, "+proj=longlat +a=15000 +b=8000 +no_defs"},
            //{61410, ""},
            //{61411, ""},
            //{61412, ""},
            //{61413, ""},
            {61414, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61415, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61416, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61417, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61418, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61419, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61420, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61421, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61460, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61461, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61462, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61463, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61464, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61465, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61466, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61467, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            //{61468, ""},
            //{61469, ""},
            //{61470, ""},
            //{61471, ""},
            {61472, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            {61473, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs"},
            //{61474, ""},
            //{61475, ""},
            //{61476, ""},
            //{61477, ""},
            //{61478, ""},
            //{61479, ""},
            {61500, "+proj=longlat +a=18500 +b=13500 +no_defs"},
            {61501, "+proj=longlat +a=18500 +b=13500 +no_defs"},
            //{61510, ""},
            //{61511, ""},
            //{61512, ""},
            //{61513, ""},
            {61514, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61515, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61516, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61517, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61518, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61519, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61520, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61521, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61560, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61561, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61562, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61563, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61564, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61565, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61566, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61567, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            //{61568, ""},
            //{61569, ""},
            //{61570, ""},
            //{61571, ""},
            {61572, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            {61573, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs"},
            //{61574, ""},
            //{61575, ""},
            //{61576, ""},
            //{61577, ""},
            //{61578, ""},
            //{61579, ""},
            {61600, "+proj=longlat +a=74000 +b=34000 +no_defs"},
            {61601, "+proj=longlat +a=74000 +b=34000 +no_defs"},
            //{61610, ""},
            //{61611, ""},
            //{61612, ""},
            //{61613, ""},
            {61614, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61615, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61616, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61617, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61618, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61619, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61620, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61621, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61660, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61661, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61662, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61663, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61664, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61665, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61666, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61667, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            //{61668, ""},
            //{61669, ""},
            //{61670, ""},
            //{61671, ""},
            {61672, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            {61673, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs"},
            //{61674, ""},
            //{61675, ""},
            //{61676, ""},
            //{61677, ""},
            //{61678, ""},
            //{61679, ""},
            {61700, "+proj=longlat +a=55000 +b=31000 +no_defs"},
            {61701, "+proj=longlat +a=55000 +b=31000 +no_defs"},
            //{61710, ""},
            //{61711, ""},
            //{61712, ""},
            //{61713, ""},
            {61714, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61715, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61716, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61717, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61718, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61719, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61720, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61721, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61760, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61761, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61762, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61763, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61764, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61765, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61766, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61767, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            //{61768, ""},
            //{61769, ""},
            //{61770, ""},
            //{61771, ""},
            {61772, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            {61773, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs"},
            //{61774, ""},
            //{61775, ""},
            //{61776, ""},
            //{61777, ""},
            //{61778, ""},
            //{61779, ""},
            {61800, "+proj=longlat +a=10000 +b=10000 +no_defs"},
            {61801, "+proj=longlat +a=10000 +b=10000 +no_defs"},
            //{61810, ""},
            //{61811, ""},
            //{61812, ""},
            //{61813, ""},
            {61814, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61815, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61816, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61817, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61818, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61819, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61820, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61821, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61860, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61861, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61862, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61863, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61864, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61865, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61866, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61867, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            //{61868, ""},
            //{61869, ""},
            //{61870, ""},
            //{61871, ""},
            {61872, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            {61873, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs"},
            //{61874, ""},
            //{61875, ""},
            //{61876, ""},
            //{61877, ""},
            //{61878, ""},
            //{61879, ""},
            {69900, "+proj=longlat +a=60268000 +b=54364000 +no_defs"},
            {69901, "+proj=longlat +a=60268000 +b=54364000 +no_defs"},
            //{69910, ""},
            //{69911, ""},
            //{69912, ""},
            //{69913, ""},
            {69914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            //{69968, ""},
            //{69969, ""},
            //{69970, ""},
            //{69971, ""},
            {69972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            {69973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs"},
            //{69974, ""},
            //{69975, ""},
            //{69976, ""},
            //{69977, ""},
            //{69978, ""},
            //{69979, ""},
            {70100, "+proj=longlat +a=581100 +b=577700 +no_defs"},
            {70101, "+proj=longlat +a=581100 +b=577700 +no_defs"},
            //{70110, ""},
            //{70111, ""},
            //{70112, ""},
            //{70113, ""},
            {70114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            //{70168, ""},
            //{70169, ""},
            //{70170, ""},
            //{70171, ""},
            {70172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            {70173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs"},
            //{70174, ""},
            //{70175, ""},
            //{70176, ""},
            //{70177, ""},
            //{70178, ""},
            //{70179, ""},
            {70200, "+proj=longlat +a=584700 +b=584700 +no_defs"},
            {70201, "+proj=longlat +a=584700 +b=584700 +no_defs"},
            //{70210, ""},
            //{70211, ""},
            //{70212, ""},
            //{70213, ""},
            {70214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            //{70268, ""},
            //{70269, ""},
            //{70270, ""},
            //{70271, ""},
            {70272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            {70273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs"},
            //{70274, ""},
            //{70275, ""},
            //{70276, ""},
            //{70277, ""},
            //{70278, ""},
            //{70279, ""},
            {70300, "+proj=longlat +a=788900 +b=788900 +no_defs"},
            {70301, "+proj=longlat +a=788900 +b=788900 +no_defs"},
            //{70310, ""},
            //{70311, ""},
            //{70312, ""},
            //{70313, ""},
            {70314, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70315, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70316, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70317, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70318, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70319, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70320, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70321, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70360, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70361, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70362, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70363, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70364, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70365, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70366, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70367, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            //{70368, ""},
            //{70369, ""},
            //{70370, ""},
            //{70371, ""},
            {70372, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            {70373, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs"},
            //{70374, ""},
            //{70375, ""},
            //{70376, ""},
            //{70377, ""},
            //{70378, ""},
            //{70379, ""},
            {70400, "+proj=longlat +a=761400 +b=761400 +no_defs"},
            {70401, "+proj=longlat +a=761400 +b=761400 +no_defs"},
            //{70410, ""},
            //{70411, ""},
            //{70412, ""},
            //{70413, ""},
            {70414, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70415, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70416, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70417, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70418, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70419, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70420, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70421, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70460, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70461, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70462, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70463, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70464, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70465, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70466, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70467, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            //{70468, ""},
            //{70469, ""},
            //{70470, ""},
            //{70471, ""},
            {70472, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            {70473, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs"},
            //{70474, ""},
            //{70475, ""},
            //{70476, ""},
            //{70477, ""},
            //{70478, ""},
            //{70479, ""},
            {70500, "+proj=longlat +a=240400 +b=232900 +no_defs"},
            {70501, "+proj=longlat +a=240400 +b=232900 +no_defs"},
            //{70510, ""},
            //{70511, ""},
            //{70512, ""},
            //{70513, ""},
            {70514, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70515, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70516, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70517, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70518, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70519, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70520, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70521, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70560, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70561, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70562, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70563, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70564, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70565, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70566, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70567, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            //{70568, ""},
            //{70569, ""},
            //{70570, ""},
            //{70571, ""},
            {70572, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            {70573, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs"},
            //{70574, ""},
            //{70575, ""},
            //{70576, ""},
            //{70577, ""},
            //{70578, ""},
            //{70579, ""},
            {70600, "+proj=longlat +a=13000 +b=13000 +no_defs"},
            {70601, "+proj=longlat +a=13000 +b=13000 +no_defs"},
            //{70610, ""},
            //{70611, ""},
            //{70612, ""},
            //{70613, ""},
            {70614, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70615, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70616, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70617, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70618, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70619, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70620, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70621, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70660, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70661, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70662, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70663, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70664, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70665, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70666, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70667, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            //{70668, ""},
            //{70669, ""},
            //{70670, ""},
            //{70671, ""},
            {70672, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            {70673, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs"},
            //{70674, ""},
            //{70675, ""},
            //{70676, ""},
            //{70677, ""},
            //{70678, ""},
            //{70679, ""},
            {70700, "+proj=longlat +a=15000 +b=15000 +no_defs"},
            {70701, "+proj=longlat +a=15000 +b=15000 +no_defs"},
            //{70710, ""},
            //{70711, ""},
            //{70712, ""},
            //{70713, ""},
            {70714, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70715, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70716, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70717, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70718, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70719, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70720, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70721, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70760, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70761, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70762, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70763, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70764, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70765, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70766, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70767, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            //{70768, ""},
            //{70769, ""},
            //{70770, ""},
            //{70771, ""},
            {70772, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            {70773, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs"},
            //{70774, ""},
            //{70775, ""},
            //{70776, ""},
            //{70777, ""},
            //{70778, ""},
            //{70779, ""},
            {70800, "+proj=longlat +a=21000 +b=21000 +no_defs"},
            {70801, "+proj=longlat +a=21000 +b=21000 +no_defs"},
            //{70810, ""},
            //{70811, ""},
            //{70812, ""},
            //{70813, ""},
            {70814, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70815, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70816, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70817, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70818, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70819, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70820, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70821, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70860, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70861, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70862, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70863, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70864, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70865, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70866, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70867, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            //{70868, ""},
            //{70869, ""},
            //{70870, ""},
            //{70871, ""},
            {70872, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            {70873, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs"},
            //{70874, ""},
            //{70875, ""},
            //{70876, ""},
            //{70877, ""},
            //{70878, ""},
            //{70879, ""},
            {70900, "+proj=longlat +a=31000 +b=31000 +no_defs"},
            {70901, "+proj=longlat +a=31000 +b=31000 +no_defs"},
            //{70910, ""},
            //{70911, ""},
            //{70912, ""},
            //{70913, ""},
            {70914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            //{70968, ""},
            //{70969, ""},
            //{70970, ""},
            //{70971, ""},
            {70972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            {70973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs"},
            //{70974, ""},
            //{70975, ""},
            //{70976, ""},
            //{70977, ""},
            //{70978, ""},
            //{70979, ""},
            {71000, "+proj=longlat +a=27000 +b=27000 +no_defs"},
            {71001, "+proj=longlat +a=27000 +b=27000 +no_defs"},
            //{71010, ""},
            //{71011, ""},
            //{71012, ""},
            //{71013, ""},
            {71014, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71015, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71016, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71017, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71018, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71019, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71020, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71021, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71060, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71061, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71062, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71063, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71064, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71065, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71066, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71067, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            //{71068, ""},
            //{71069, ""},
            //{71070, ""},
            //{71071, ""},
            {71072, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71073, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            //{71074, ""},
            //{71075, ""},
            //{71076, ""},
            //{71077, ""},
            //{71078, ""},
            //{71079, ""},
            {71100, "+proj=longlat +a=42000 +b=42000 +no_defs"},
            {71101, "+proj=longlat +a=42000 +b=42000 +no_defs"},
            //{71110, ""},
            //{71111, ""},
            //{71112, ""},
            //{71113, ""},
            {71114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            //{71168, ""},
            //{71169, ""},
            //{71170, ""},
            //{71171, ""},
            {71172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            {71173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs"},
            //{71174, ""},
            //{71175, ""},
            //{71176, ""},
            //{71177, ""},
            //{71178, ""},
            //{71179, ""},
            {71200, "+proj=longlat +a=54000 +b=54000 +no_defs"},
            {71201, "+proj=longlat +a=54000 +b=54000 +no_defs"},
            //{71210, ""},
            //{71211, ""},
            //{71212, ""},
            //{71213, ""},
            {71214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            //{71268, ""},
            //{71269, ""},
            //{71270, ""},
            //{71271, ""},
            {71272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            {71273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs"},
            //{71274, ""},
            //{71275, ""},
            //{71276, ""},
            //{71277, ""},
            //{71278, ""},
            //{71279, ""},
            {71300, "+proj=longlat +a=27000 +b=27000 +no_defs"},
            {71301, "+proj=longlat +a=27000 +b=27000 +no_defs"},
            //{71310, ""},
            //{71311, ""},
            //{71312, ""},
            //{71313, ""},
            {71314, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71315, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71316, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71317, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71318, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71319, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71320, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71321, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71360, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71361, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71362, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71363, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71364, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71365, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71366, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71367, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            //{71368, ""},
            //{71369, ""},
            //{71370, ""},
            //{71371, ""},
            {71372, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            {71373, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs"},
            //{71374, ""},
            //{71375, ""},
            //{71376, ""},
            //{71377, ""},
            //{71378, ""},
            //{71379, ""},
            {71400, "+proj=longlat +a=33000 +b=33000 +no_defs"},
            {71401, "+proj=longlat +a=33000 +b=33000 +no_defs"},
            //{71410, ""},
            //{71411, ""},
            //{71412, ""},
            //{71413, ""},
            {71414, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71415, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71416, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71417, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71418, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71419, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71420, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71421, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71460, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71461, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71462, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71463, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71464, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71465, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71466, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71467, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            //{71468, ""},
            //{71469, ""},
            //{71470, ""},
            //{71471, ""},
            {71472, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            {71473, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs"},
            //{71474, ""},
            //{71475, ""},
            //{71476, ""},
            //{71477, ""},
            //{71478, ""},
            //{71479, ""},
            {71500, "+proj=longlat +a=77000 +b=77000 +no_defs"},
            {71501, "+proj=longlat +a=77000 +b=77000 +no_defs"},
            //{71510, ""},
            //{71511, ""},
            //{71512, ""},
            //{71513, ""},
            {71514, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71515, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71516, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71517, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71518, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71519, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71520, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71521, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71560, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71561, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71562, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71563, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71564, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71565, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71566, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71567, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            //{71568, ""},
            //{71569, ""},
            //{71570, ""},
            //{71571, ""},
            {71572, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            {71573, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs"},
            //{71574, ""},
            //{71575, ""},
            //{71576, ""},
            //{71577, ""},
            //{71578, ""},
            //{71579, ""},
            {79900, "+proj=longlat +a=25559000 +b=24973000 +no_defs"},
            {79901, "+proj=longlat +a=25559000 +b=24973000 +no_defs"},
            //{79910, ""},
            //{79911, ""},
            //{79912, ""},
            //{79913, ""},
            {79914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            //{79968, ""},
            //{79969, ""},
            //{79970, ""},
            //{79971, ""},
            {79972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            {79973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs"},
            //{79974, ""},
            //{79975, ""},
            //{79976, ""},
            //{79977, ""},
            //{79978, ""},
            //{79979, ""},
            {80100, "+proj=longlat +a=1352600 +b=1352600 +no_defs"},
            {80101, "+proj=longlat +a=1352600 +b=1352600 +no_defs"},
            //{80110, ""},
            //{80111, ""},
            //{80112, ""},
            //{80113, ""},
            {80114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            //{80168, ""},
            //{80169, ""},
            //{80170, ""},
            //{80171, ""},
            {80172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            {80173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs"},
            //{80174, ""},
            //{80175, ""},
            //{80176, ""},
            //{80177, ""},
            //{80178, ""},
            //{80179, ""},
            {80200, "+proj=longlat +a=170000 +b=170000 +no_defs"},
            {80201, "+proj=longlat +a=170000 +b=170000 +no_defs"},
            //{80210, ""},
            //{80211, ""},
            //{80212, ""},
            //{80213, ""},
            {80214, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80215, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80216, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80217, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80218, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80219, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80220, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80221, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80260, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80261, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80262, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80263, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80264, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80265, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80266, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80267, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            //{80268, ""},
            //{80269, ""},
            //{80270, ""},
            //{80271, ""},
            {80272, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            {80273, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs"},
            //{80274, ""},
            //{80275, ""},
            //{80276, ""},
            //{80277, ""},
            //{80278, ""},
            //{80279, ""},
            {80300, "+proj=longlat +a=29000 +b=29000 +no_defs"},
            {80301, "+proj=longlat +a=29000 +b=29000 +no_defs"},
            //{80310, ""},
            //{80311, ""},
            //{80312, ""},
            //{80313, ""},
            {80314, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80315, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80316, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80317, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80318, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80319, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80320, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80321, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80360, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80361, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80362, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80363, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80364, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80365, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80366, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80367, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            //{80368, ""},
            //{80369, ""},
            //{80370, ""},
            //{80371, ""},
            {80372, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            {80373, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs"},
            //{80374, ""},
            //{80375, ""},
            //{80376, ""},
            //{80377, ""},
            //{80378, ""},
            //{80379, ""},
            {80400, "+proj=longlat +a=40000 +b=40000 +no_defs"},
            {80401, "+proj=longlat +a=40000 +b=40000 +no_defs"},
            //{80410, ""},
            //{80411, ""},
            //{80412, ""},
            //{80413, ""},
            {80414, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80415, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80416, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80417, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80418, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80419, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80420, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80421, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80460, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80461, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80462, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80463, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80464, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80465, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80466, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80467, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            //{80468, ""},
            //{80469, ""},
            //{80470, ""},
            //{80471, ""},
            {80472, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            {80473, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs"},
            //{80474, ""},
            //{80475, ""},
            //{80476, ""},
            //{80477, ""},
            //{80478, ""},
            //{80479, ""},
            {80500, "+proj=longlat +a=74000 +b=74000 +no_defs"},
            {80501, "+proj=longlat +a=74000 +b=74000 +no_defs"},
            //{80510, ""},
            //{80511, ""},
            //{80512, ""},
            //{80513, ""},
            {80514, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80515, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80516, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80517, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80518, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80519, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80520, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80521, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80560, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80561, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80562, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80563, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80564, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80565, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80566, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80567, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            //{80568, ""},
            //{80569, ""},
            //{80570, ""},
            //{80571, ""},
            {80572, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            {80573, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs"},
            //{80574, ""},
            //{80575, ""},
            //{80576, ""},
            //{80577, ""},
            //{80578, ""},
            //{80579, ""},
            {80600, "+proj=longlat +a=79000 +b=79000 +no_defs"},
            {80601, "+proj=longlat +a=79000 +b=79000 +no_defs"},
            //{80610, ""},
            //{80611, ""},
            //{80612, ""},
            //{80613, ""},
            {80614, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80615, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80616, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80617, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80618, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80619, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80620, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80621, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80660, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80661, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80662, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80663, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80664, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80665, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80666, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80667, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            //{80668, ""},
            //{80669, ""},
            //{80670, ""},
            //{80671, ""},
            {80672, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            {80673, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs"},
            //{80674, ""},
            //{80675, ""},
            //{80676, ""},
            //{80677, ""},
            //{80678, ""},
            //{80679, ""},
            {80700, "+proj=longlat +a=96000 +b=96000 +no_defs"},
            {80701, "+proj=longlat +a=96000 +b=96000 +no_defs"},
            //{80710, ""},
            //{80711, ""},
            //{80712, ""},
            //{80713, ""},
            {80714, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80715, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80716, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80717, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80718, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80719, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80720, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80721, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80760, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80761, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80762, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80763, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80764, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80765, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80766, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80767, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            //{80768, ""},
            //{80769, ""},
            //{80770, ""},
            //{80771, ""},
            {80772, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            {80773, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs"},
            //{80774, ""},
            //{80775, ""},
            //{80776, ""},
            //{80777, ""},
            //{80778, ""},
            //{80779, ""},
            {80800, "+proj=longlat +a=218000 +b=201000 +no_defs"},
            {80801, "+proj=longlat +a=218000 +b=201000 +no_defs"},
            //{80810, ""},
            //{80811, ""},
            //{80812, ""},
            //{80813, ""},
            {80814, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80815, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80816, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80817, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80818, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80819, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80820, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80821, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80860, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80861, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80862, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80863, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80864, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80865, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80866, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80867, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            //{80868, ""},
            //{80869, ""},
            //{80870, ""},
            //{80871, ""},
            {80872, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            {80873, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs"},
            //{80874, ""},
            //{80875, ""},
            //{80876, ""},
            //{80877, ""},
            //{80878, ""},
            //{80879, ""},
            {89900, "+proj=longlat +a=24764000 +b=24341000 +no_defs"},
            {89901, "+proj=longlat +a=24764000 +b=24341000 +no_defs"},
            //{89910, ""},
            //{89911, ""},
            //{89912, ""},
            //{89913, ""},
            {89914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            //{89968, ""},
            //{89969, ""},
            //{89970, ""},
            //{89971, ""},
            {89972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            {89973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs"},
            //{89974, ""},
            //{89975, ""},
            //{89976, ""},
            //{89977, ""},
            //{89978, ""},
            //{89979, ""},
            {90100, "+proj=longlat +a=593000 +b=593000 +no_defs"},
            {90101, "+proj=longlat +a=593000 +b=593000 +no_defs"},
            //{90110, ""},
            //{90111, ""},
            //{90112, ""},
            //{90113, ""},
            {90114, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90115, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90116, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90117, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90118, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90119, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90120, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90121, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90160, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90161, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90162, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90163, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90164, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90165, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90166, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90167, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            //{90168, ""},
            //{90169, ""},
            //{90170, ""},
            //{90171, ""},
            {90172, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            {90173, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs"},
            //{90174, ""},
            //{90175, ""},
            //{90176, ""},
            //{90177, ""},
            //{90178, ""},
            //{90179, ""},
            {99900, "+proj=longlat +a=1195000 +b=1195000 +no_defs"},
            {99901, "+proj=longlat +a=1195000 +b=1195000 +no_defs"},
            //{99910, ""},
            //{99911, ""},
            //{99912, ""},
            //{99913, ""},
            {99914, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99915, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99916, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99917, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99918, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99919, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99920, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99921, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99960, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99961, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99962, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99963, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99964, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99965, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99966, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99967, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            //{99968, ""},
            //{99969, ""},
            //{99970, ""},
            //{99971, ""},
            {99972, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"},
            {99973, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs"}
//{99974, ""},
//{99975, ""},
//{99976, ""},
//{99977, ""},
//{99978, ""},
//{99979, ""}
        };

        const code_element * first = arr;
        const code_element * last = arr + sizeof(arr) / sizeof(code_element);
        const code_element * el = binary_find_code_element(first, last, code);

        return el != last ? el->proj4_str : "";
    }

}
#endif // DOXYGEN_NO_DETAIL


}}} // namespace boost::geometry::projections

#endif
