################################################
# Firewall Rules:4 for 4 ports
################################################
p 1 firewall add ipv4 1 0.0.0.0 8 0.0.0.0 10 0 0 0 0 6 1 0
p 1 firewall add ipv4 1 0.0.0.0 8 0.64.0.0 10 0 0 0 0 6 1 1
p 1 firewall add ipv4 1 0.0.0.0 8 0.128.0.0 10 0 0 0 0 6 1 2
p 1 firewall add ipv4 1 0.0.0.0 8 0.192.0.0 10 0 0 0 0 6 1 3
p 1 firewall add default 4 #SINK0


################################################################################
# Flow classification
################################################################################
p 3 flow add default 4 #SINK1
p 3 flow add qinq all 65536 4

################################################################################
# Flow Actions - Metering
################################################################################
p 4 flows 65536 meter 0 trtcm 1250000000 1250000000 100000000 100000000
p 4 flows 65536 ports 4

################################################################################
# Routing: Ether MPLS, ARP off
################################################################################
p 5 route add default 4 #SINK2
p 5 route add 0.0.0.0 10 port 0 ether a0:b0:c0:d0:e0:f0 mpls 0:1
p 5 route add 0.64.0.0 10 port 1 ether a1:b1:c1:d1:e1:f1 mpls 10:11
p 5 route add 0.128.0.0 10 port 2 ether a2:b2:c2:d2:e2:f2 mpls 20:21
p 5 route add 0.192.0.0 10 port 3 ether a3:b3:c3:d3:e3:f3 mpls 30:31

################################################################################
# List all configurations
################################################################################
p 1 firewall ls
#p 3 flow ls
#p 4 flow actions ls
p 5 route ls
