+++
title = "Upgrade guide v2.1 => v2.2"
weight = 20
+++

After a year of listening to user feedback since entering Boost,
Outcome v2.2 has a number of breaking source changes from Outcome v2.1
which were published start of 2020 in the [`better_optimisation`](https://github.com/ned14/outcome/tree/better_optimisation)
branch. The full year of 2020 (three Boost releases) was given to
announcing those upcoming changes, and testing the v2.2 branch in
production. The tutorial remains based on v2.1, as that remains the
stable branch. However in early 2021 the tutorial shall be ported
to v2.2.

To upgrade an Outcome v2.1 based codebase to Outcome v2.2 is very easy:

1. You will need a tool capable of finding regular expressions in all source
files in a directory tree and replacing them -- most IDEs such as Visual Studio
have such a tool with GUI, on POSIX a shell script such as this ought to work:

        find /path/to/project -type f -name "*.hpp" | xargs sed -i "s/_TRY\(([^(]*?),(.*?)\);/_TRY(auto &&\1,\2);/g"
        find /path/to/project -type f -name "*.cpp" | xargs sed -i "s/_TRY\(([^(]*?),(.*?)\);/_TRY(auto &&\1,\2);/g"

    The transformation needed is the regular expression `_TRY\(([^(]*?),(.*?)\);` =>
    `_TRY(auto &&\1,\2);`. This is because in Outcome v2.2 onwards, `BOOST_OUTCOME_TRY(var, expr)`
    no longer implicitly declares the variable created as `auto&&` on your behalf,
    now you must specify the storage of the variable.

    The principle advantage of this change is that you can now assign to
    existing variables the successful results of expressions, instead of being
    forced to TRY into a new variable, and move that variable into the destination
    you intended. Also, because you can now specify storage, you can now assign
    the result of a TRYied operation into static or thread local storage.

2. If your code uses [the ADL discovered event hooks]({{% relref "/tutorial/advanced/hooks" %}})
to intercept when `basic_result` and `basic_outcome` is constructed, copies or
moved, you will need to either define the macro {{% api "BOOST_OUTCOME_ENABLE_LEGACY_SUPPORT_FOR" %}}
to less than `220` to enable emulation, or upgrade the code to use the new mechanism.

    The hooks themselves have identical signature, [only the name and location has
    changed]({{% relref "/tutorial/advanced/hooks" %}}). Therefore upgrade is usually
    a case of copy-pasting the hook implementation into a custom `NoValuePolicy`
    implementation, and changing the ADL free function's name from `hook_*` to `on_*`.

    You are recommended to upgrade if possible, as the ADL discovered hooks were
    found in real world code usage to be brittle and surprising.

3. Any usage of CamelCase named concepts from Outcome must be replaced with snake_case
named concepts instead:

    - `concepts::ValueOrError<T>` => `concepts::value_or_error<T>`
    - `concepts::ValueOrNone<T>` => `concepts::value_or_none<T>`

    The CamelCase naming is aliased to the snake_case naming if the macro
    {{% api "BOOST_OUTCOME_ENABLE_LEGACY_SUPPORT_FOR" %}} is defined to less than `220`.
    Nevertheless you ought to upgrade here is possible, as due to a late change
    in C++ 20 all standard concepts are now snake_case named.

4. Finally, despite that Outcome does not currently offer a stable ABI guarantee
(hoped to begin in 2022), v2.1 had a stable storage layout for `basic_result` and
`basic_outcome`. In v2.2 that storage layout has changed, so the ABIs generated by
use of v2.1 and v2.2 are incompatible i.e. you will need to recompile everything
using Outcome after you upgrade to v2.2.
